#!/bin/bash

config_base="IRIS/config_iris"

# Configurations
dataset_key="IRIS"
model_key="RFC"

# Perturbation type
pert_key="Base_Perturbations"

# special for MeLIME (scale=1, not scale=0)
scale_melime="0"
maple_leaves="5"

# Dataset specific
cnts="10 20 30 40 50"
num_envs="2 3 4 5"
kws="0.1 0.2 0.5 1.0 1.5"


n_jobs="25"

for cnt in ${cnts}
do
    for num_env in ${num_envs}
    do
        for kw in ${kws}
        do

config_file=${config_base}"_"${kw}"_"${num_env}"_"$cnt".yaml"

echo ${config_file} ${dataset_key}

echo "1_data_preproc"
python 1_data_preproc.py --config_fname ${config_file} --dataset_key ${dataset_key}

echo "2_train_bb_model"
python 2_train_bb_model.py --config_fname ${config_file} --dataset_key ${dataset_key} --model_key ${model_key}

echo "3_create_base_perturbations"
python 3_create_base_perturbations.py --config_fname ${config_file} --dataset_key ${dataset_key} --n_jobs ${n_jobs} --pert_key ${pert_key}

echo "4_create_neighborhood_bb_preds"
python 4_create_neighborhood_bb_preds.py --config_fname ${config_file} --dataset_key ${dataset_key} --model_key ${model_key} --pert_key ${pert_key}

echo "5_create_env_perturbations"
python 5_create_env_perturbations.py --config_fname ${config_file} --dataset_key ${dataset_key} --pert_key ${pert_key}

echo "6_LIME_explanations"
python 6_LIME_explanations.py --config_fname ${config_file} --dataset_key ${dataset_key}\
            --model_key ${model_key} --pert_key ${pert_key} --maple_leaves ${maple_leaves}

echo "7_LINEX_explanations"
python 7_LINEX_explanations.py --config_fname ${config_file} --dataset_key ${dataset_key}\
            --model_key ${model_key} --pert_key ${pert_key} --maple_leaves ${maple_leaves}\
            --num_cpus ${n_jobs}


        done
    done
done
